extends Button
class_name SkinHolder

# Skin holder class for managing purchased skins in the skins scenes

var _id := 0 setget , get_id
var _texture : Texture setget , get_texture

onready var _skin_texture : TextureRect = get_node("skin_bg/skin_text")
onready var _random : Label = get_node("skin_bg/random")
onready var _selected_icon : TextureRect = get_node("skin_bg/selected")
onready var _animation : AnimationPlayer = get_node("AnimationPlayer")


# Called when the node enters the scene tree for the first time.
func _ready():
	pass # Replace with function body.


func init(id : int , texture : Texture) -> void:
	_id = id
	_texture = texture
	_skin_texture.texture = _texture


func get_id() -> int:
	return _id

func get_texture() -> Texture:
	return _texture


func select() -> void: # make skin selected
	Sounds.play_tap_sound()
	_selected_icon.visible = true


func unselect()-> void:# unselect skin
	_selected_icon.visible = false


func lock() -> void:
	_random.visible = true
	_skin_texture.visible = false


func unlock() -> void:
	_random.visible = false
	_skin_texture.visible = true
	_skin_texture.rect_scale = Vector2(1,1) # Purchase animation scale it to 0


func purchase() -> void:
	_animation.play("skin_holder_unlock")
	yield(_animation,"animation_finished")
	unlock()
